/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.item;

import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRMaterial;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class LOTRItemSword
extends ItemSword {
    @SideOnly(value=Side.CLIENT)
    public IIcon glowingIcon;
    private boolean isElvenBlade = false;
    protected float lotrWeaponDamage;
    public HitEffect effect;

    public LOTRItemSword(LOTRMaterial material) {
        this(material.toToolMaterial());
    }

    public LOTRItemSword(Item.ToolMaterial material) {
        super(material);
        this.func_77637_a(LOTRCreativeTabs.tabCombat);
        this.lotrWeaponDamage = material.func_78000_c() + 4.0f;
    }

    public LOTRItemSword addWeaponDamage(float f) {
        this.lotrWeaponDamage += f;
        return this;
    }

    public float getLOTRWeaponDamage() {
        return this.lotrWeaponDamage;
    }

    public LOTRItemSword setIsElvenBlade() {
        this.isElvenBlade = true;
        return this;
    }

    public boolean isElvenBlade() {
        return this.isElvenBlade;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconregister) {
        super.func_94581_a(iconregister);
        if (this.isElvenBlade) {
            this.glowingIcon = iconregister.func_94245_a(this.func_111208_A() + "_glowing");
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (this.func_77661_b(itemstack) == EnumAction.none) {
            return itemstack;
        }
        return super.func_77659_a(itemstack, world, entityplayer);
    }

    public Multimap func_111205_h() {
        Multimap multimap = super.func_111205_h();
        multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "LOTR Weapon modifier", (double)this.lotrWeaponDamage, 0));
        return multimap;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase hitEntity, EntityLivingBase user) {
        itemstack.func_77972_a(1, user);
        if (this.effect == HitEffect.NONE) {
            return true;
        }
        if (this.effect == HitEffect.POISON) {
            LOTRItemSword.applyStandardPoison(hitEntity);
        }
        if (this.effect == HitEffect.FIRE) {
            LOTRItemSword.applyStandardFire(hitEntity);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (player != null) {
            String factionName;
            int reputation;
            LOTRPlayerData playerData = LOTRLevelData.getData(player);
            LOTRFaction pledgeFaction = playerData.getPledgeFaction();
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TREE) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else if (reputation >= 10000 && reputation < 15000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                } else if (reputation >= 20000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.entDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_TROLL) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                list.add(EnumChatFormatting.GREEN + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                if (reputation < 20000) {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 20000}));
                } else {
                    list.add("");
                    list.add(EnumChatFormatting.GREEN + "\u2694 " + I18n.func_135052_a((String)"item.hammer.trollDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_ORC) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.RED + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_DWARF) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 10000) {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 10000}));
                } else {
                    list.add(EnumChatFormatting.GOLD + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.GOLD + "\u2694 " + I18n.func_135052_a((String)"item.hammer.dwarfDamage.active", (Object[])new Object[]{"2.0"}));
                }
            }
            if (pledgeFaction != null && this.getPriorityFactionType(pledgeFaction.getFactionTypes()) == LOTRFaction.FactionType.TYPE_MAN) {
                reputation = Math.round(playerData.getAlignment(pledgeFaction));
                factionName = pledgeFaction.factionName();
                if (reputation < 5000) {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.bonusDamage.info", (Object[])new Object[]{reputation, 5000}));
                } else {
                    list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"item.armor.pledge", (Object[])new Object[]{factionName}));
                    list.add("");
                    list.add(EnumChatFormatting.YELLOW + "\u2694 " + I18n.func_135052_a((String)"item.hammer.manDamage.active", (Object[])new Object[]{"3.0"}));
                }
            }
        }
    }

    private LOTRFaction.FactionType getPriorityFactionType(Set<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TREE)) {
            return LOTRFaction.FactionType.TYPE_TREE;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_TROLL)) {
            return LOTRFaction.FactionType.TYPE_TROLL;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    public static void applyStandardFire(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 4;
        entity.func_70015_d(duration);
    }

    public static void applyStandardPoison(EntityLivingBase entity) {
        EnumDifficulty difficulty = entity.field_70170_p.field_73013_u;
        int duration = 1 + difficulty.func_151525_a() * 2;
        PotionEffect poison = new PotionEffect(Potion.field_76436_u.field_76415_H, (duration + field_77697_d.nextInt(duration)) * 20);
        entity.func_70690_d(poison);
    }

    public static UUID accessWeaponDamageModifier() {
        return field_111210_e;
    }

    public static enum HitEffect {
        NONE,
        FIRE,
        POISON;

    }
}

